#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AntibodyParameter : BaseTest 
	{
		
		private DataTable _dtAntibodyParameter;
		private BOL.AntibodyParameter _tstAntibodyParameter;
		private int _antibodyTypeId;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtAntibodyParameter = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntibodyParameter WHERE CompatibilityPercentage IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				
				this.RefreshData = false;
			}
			
			//Do it once for code reuse
			this._antibodyTypeId = (int)this._dtAntibodyParameter.Rows[0][TABLES.AntibodyType.AntibodyTypeId];

			this._tstAntibodyParameter = new BOL.AntibodyParameter(this._antibodyTypeId);
		}

		[Test]
		public void Ctor_Id_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.AntibodyParameterGuid];

			Assert.AreEqual(this._antibodyTypeId, this._tstAntibodyParameter.AntibodyTypeId, TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(unitGuid, this._tstAntibodyParameter.AntibodyParameterGuid, TABLES.AntibodyParameter.AntibodyParameterGuid);
			Assert.AreEqual(false, this._tstAntibodyParameter.IsNew, "IsNew");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_Id_Fail()
		{
			BOL.AntibodyParameter tstObj = new BOL.AntibodyParameter(-1);
		}

		[Test]
		public void AntibodyParameterGuid_Pass()
		{
			System.Guid testGuid = System.Guid.NewGuid();

			this._tstAntibodyParameter.AntibodyParameterGuid = testGuid;

			Assert.AreEqual(testGuid, this._tstAntibodyParameter.AntibodyParameterGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntibodyParameterGuid_Fail()
		{
		}

		[Test]
		public void AntibodyTypeId_Pass()
		{
			int testInt = new Random().Next(999);

			this._tstAntibodyParameter.AntibodyTypeId = testInt;

			Assert.AreEqual(testInt, this._tstAntibodyParameter.AntibodyTypeId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntibodyTypeId_Fail()
		{
		}

		[Test]
		public void HigherLevelOverrideIndicator_Pass()
		{
			this._tstAntibodyParameter.HigherLevelOverrideIndicator = true;

			Assert.AreEqual(true, this._tstAntibodyParameter.HigherLevelOverrideIndicator);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void HigherLevelOverrideIndicator_Fail()
		{
		}

		[Test]
		public void CanChangeIndicator_Pass()
		{
			this._tstAntibodyParameter.CanChangeIndicator = true;

			Assert.AreEqual(true, this._tstAntibodyParameter.CanChangeIndicator);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CanChangeIndicator_Fail()
		{
		}

		[Test]
		public void CompatibilityPercentage_Pass()
		{
			int testInt = new Random().Next(99);

			this._tstAntibodyParameter.CompatibilityPercentage = testInt;

			Assert.AreEqual(testInt, this._tstAntibodyParameter.CompatibilityPercentage);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CompatibilityPercentage_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			Assert.AreEqual(this.TestDivisionCode.Trim(), this._tstAntibodyParameter.DivisionCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DivisionCode_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drBlank = this._dtAntibodyParameter.NewRow();
			DataRow drCheck = this._tstAntibodyParameter.LoadDataRowFromThis(drBlank);

			Assert.AreEqual(this._tstAntibodyParameter.AntibodyParameterGuid, (System.Guid)drCheck[TABLES.AntibodyParameter.AntibodyParameterGuid], TABLES.AntibodyParameter.AntibodyParameterGuid);
			Assert.AreEqual(this._tstAntibodyParameter.AntibodyTypeId,  (int)drCheck[TABLES.AntibodyType.AntibodyTypeId], TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(this._tstAntibodyParameter.CanChangeIndicator, (bool)drCheck[TABLES.AntibodyParameter.CanChangeIndicator], TABLES.AntibodyParameter.CanChangeIndicator);
			Assert.AreEqual(this._tstAntibodyParameter.HigherLevelOverrideIndicator, (bool)drCheck[TABLES.AntibodyParameter.HigherLevelOverrideIndicator], TABLES.AntibodyParameter.HigherLevelOverrideIndicator);
			Assert.AreEqual(this._tstAntibodyParameter.CompatibilityPercentage, System.Convert.ToInt16(drCheck[TABLES.AntibodyParameter.CompatibilityPercentage]), TABLES.AntibodyParameter.CompatibilityPercentage);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}





	}
}
#endif
